/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.ILocalChiselingContextCache;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.client.chiseling.preview.render.IChiselContextPreviewRendererRegistry;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.item.chisel.IChiselItem;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.named.IDynamicallyHighlightedNameItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.notifications.INotificationManager;
import mod.chiselsandbits.chiseling.ChiselingManager;
import mod.chiselsandbits.chiseling.LocalChiselingContextCache;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import mod.chiselsandbits.registrars.ModTags;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_761;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiselItem
extends class_1766
implements IChiselItem,
IDynamicallyHighlightedNameItem {
    private static final Logger LOGGER = LogManager.getLogger();

    public ChiselItem(class_1832 tier, class_1792.class_1793 builderIn) {
        super(0.1f, -2.8f, tier, ModTags.Blocks.CHISELED_BLOCK, builderIn);
    }

    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_7948().method_10545("chiselError")) {
            return class_2561.class_2562.method_10877((String)stack.method_7948().method_10558("chiselError"));
        }
        return super.method_7864(stack);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 worldIn, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        IChiselMode mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((class_2561)TranslationUtils.build("chiselmode.mode_grouped", ((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((class_2561)TranslationUtils.build("chiselmode.mode", mode.getDisplayName()));
        }
        super.method_7851(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @NotNull
    public IChiselMode getMode(class_1799 stack) {
        class_2487 stackNbt = stack.method_7948();
        if (stackNbt.method_10545("chiselMode")) {
            String chiselModeName = stackNbt.method_10558("chiselMode");
            try {
                Optional<IChiselMode> registryMode = IChiselMode.getRegistry().get(new class_2960(chiselModeName));
                if (registryMode.isEmpty()) {
                    return IChiselMode.getDefaultMode();
                }
                return registryMode.get();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid chisel mode: %s", chiselModeName));
                this.setMode(stack, IChiselMode.getDefaultMode());
            }
        }
        return IChiselMode.getDefaultMode();
    }

    @Override
    public void setMode(class_1799 stack, IChiselMode mode) {
        if (mode == null) {
            return;
        }
        stack.method_7948().method_10582("chiselMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IChiselMode> getPossibleModes() {
        return IChiselMode.getRegistry().getValues().stream().filter(mode -> !mode.requiresPlaceableEditStack()).sorted(Comparator.comparing(IChiselsAndBitsRegistryEntry::getRegistryName)).collect(Collectors.toList());
    }

    @Override
    public ClickProcessingState handleLeftClickProcessing(class_1657 playerEntity, class_1268 hand, class_2338 position, class_2350 face, ClickProcessingState currentState) {
        class_1799 itemStack = playerEntity.method_5998(hand);
        if (itemStack.method_7960() || itemStack.method_7909() != this) {
            return currentState;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.method_7909();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        IChiselingContext context = IChiselingManager.getInstance().getOrCreateContext(playerEntity, chiselMode, ChiselingOperation.CHISELING, false, itemStack);
        ClickProcessingState resultState = chiselMode.onLeftClickBy(playerEntity, context);
        if (context.isComplete()) {
            playerEntity.method_7357().method_7906((class_1792)this, 3);
            ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
        }
        if (context.getError().isPresent() && context.getWorld().method_8608()) {
            INotificationManager.getInstance().notify(context.getMode().getIcon(), new class_243(1.0, 0.0, 0.0), (class_2561)context.getError().get());
        }
        return resultState;
    }

    @Override
    public void onLeftClickProcessingEnd(class_1657 player, class_1799 stack) {
        IChiselMode chiselMode = this.getMode(stack);
        Optional<IChiselingContext> context = IChiselingManager.getInstance().get(player, chiselMode, ChiselingOperation.CHISELING);
        if (context.isEmpty()) {
            context = LocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        }
        context.ifPresent(c -> {
            chiselMode.onStoppedLeftClicking(player, (IChiselingContext)c);
            if (c.isComplete()) {
                player.method_7357().method_7906((class_1792)this, 3);
                LocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            }
        });
    }

    @Override
    public boolean canUse(class_1657 playerEntity) {
        return ChiselingManager.getInstance().canChisel(playerEntity);
    }

    @Override
    public boolean shouldDrawDefaultHighlight(@NotNull class_1657 playerEntity) {
        class_1799 itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.method_7960() || itemStack.method_7909() != this) {
            return true;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.method_7909();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext context = potentiallyExistingContext.get();
            if (context.getMutator().isPresent()) {
                return false;
            }
            IChiselingContext currentContextSnapshot = context.createSnapshot();
            chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            return currentContextSnapshot.getMutator().isEmpty();
        }
        Optional<IChiselingContext> localCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (localCachedContext.isPresent() && localCachedContext.get().getMode().isStillValid(playerEntity, localCachedContext.get(), ChiselingOperation.CHISELING)) {
            IChiselingContext context = localCachedContext.get();
            if (context.getMode() == chiselMode && context.getMutator().isPresent()) {
                return false;
            }
            return context.getMutator().isEmpty();
        }
        IChiselingContext context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, context);
        if (!context.isComplete()) {
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, context);
        }
        return context.getMutator().isEmpty();
    }

    @Override
    public void renderHighlight(class_1657 playerEntity, class_761 worldRenderer, class_4587 matrixStack, float partialTicks) {
        IChiselingContext context;
        class_1799 itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.method_7960() || itemStack.method_7909() != this) {
            return;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.method_7909();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        Optional<IChiselingContext> potentiallyCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            context = potentiallyExistingContext.get();
            chiselMode.onLeftClickBy(playerEntity, context);
        } else if (potentiallyCachedContext.isPresent() && potentiallyCachedContext.get().getMode() == chiselMode && potentiallyCachedContext.get().getModeOfOperandus() == ChiselingOperation.CHISELING && chiselMode.isStillValid(playerEntity, potentiallyCachedContext.get(), ChiselingOperation.CHISELING)) {
            context = potentiallyCachedContext.get();
        } else {
            context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
            chiselMode.onLeftClickBy(playerEntity, context);
        }
        if (context.getMutator().isEmpty()) {
            ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            return;
        }
        if (context.getMutator().isPresent() && context.getError().isEmpty()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, context);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, context);
        }
    }

    @Override
    public boolean isDamageableDuringChiseling() {
        return true;
    }

    public int method_7841() {
        return this.method_8022().method_8025() * IServerConfiguration.getInstance().getBitSize().get().getBitsPerBlock();
    }

    public int method_31569(class_1799 p_150900_) {
        return Math.round(13.0f - (float)p_150900_.method_7919() * 13.0f / (float)this.method_7841());
    }

    public int method_31571(class_1799 p_150901_) {
        float f = Math.max(0.0f, ((float)this.method_7841() - (float)p_150901_.method_7919()) / (float)this.method_7841());
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    public class_1799 adaptItemStack(class_1799 currentToolStack) {
        Optional<IChiselingContext> chiselingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        Optional<IChiselingContext> placingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        if (chiselingContext.isPresent() && chiselingContext.get().getError().isPresent()) {
            class_1799 errorStack = currentToolStack.method_7972();
            errorStack.method_7948().method_10582("chiselError", class_2561.class_2562.method_10867((class_2561)((class_2561)chiselingContext.get().getError().get())));
            return errorStack;
        }
        if (placingContext.isPresent() && placingContext.get().getError().isPresent()) {
            class_1799 errorStack = currentToolStack.method_7972();
            errorStack.method_7948().method_10582("chiselError", class_2561.class_2562.method_10867((class_2561)((class_2561)placingContext.get().getError().get())));
            return errorStack;
        }
        return currentToolStack;
    }
}

